/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.rs6k;

import com.ibm.hsc.cim.exceptions.HSCCIMException;
import com.ibm.hsc.common.util.PIHmcAccessUtils;
import com.ibm.hsc.rep.RCimWrapper;
import com.ibm.hsc.security.HscLoginModule;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMQualifier;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbem.client.ProviderCIMOMHandle;
import org.snia.wbem.provider.InstanceProvider;
import org.snia.wbem.provider20.AssociatorProvider;
import org.snia.wbemcfg.GlobalConfig;

public class CimomWrapper {
    private static final String cimmomType = "SNIA";
    private static final String PROV_QLFR = "provider";
    private static final String All_Lpar_Tag = "|ALL_PARTITIONS*";
    public static final String objPathStr = "\\";
    public static final String defaultNameSpace = "root/ibmhscV3_2";
    public static final String[] mrTypes = new String[]{"IBMHSC_ComputerSystem", "IBMHSC_Partition", "IBMHSC_SystemProfile", "IBMHSC_LparProfile", "IBMHSC_Frame"};
    private static final int GET_ASSOCIATORS = 1;
    private static final int GET_ASSOC_NAMES = 2;
    private static final int GET_REFERENCES = 3;
    private static final int GET_REF_NAMES = 4;

    public static int getAccessMrTypeIndex(CIMObjectPath cIMObjectPath) {
        String string;
        int n = -1;
        if (cIMObjectPath == null || (string = cIMObjectPath.getObjectName()) == null) {
            return n;
        }
        for (int i = 0; i < mrTypes.length; ++i) {
            if (!mrTypes[i].equalsIgnoreCase(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public static CIMObjectPath createInstance(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        if (RCimWrapper.isRObject(cIMObjectPath) || RCimWrapper.isRAsso(cIMObjectPath)) {
            return RCimWrapper.createInstance(cIMOMHandle, cIMObjectPath, cIMInstance);
        }
        CIMObjectPath cIMObjectPath2 = null;
        ProviderCIMOMHandle providerCIMOMHandle = (ProviderCIMOMHandle)cIMOMHandle;
        InstanceProvider instanceProvider = providerCIMOMHandle.getInternalProvider();
        if (cimmomType.equalsIgnoreCase("WEBM")) {
            cIMObjectPath2 = instanceProvider.createInstance(cIMObjectPath, cIMInstance);
        } else if (cimmomType.equalsIgnoreCase(cimmomType)) {
            CIMQualifier cIMQualifier = CimomWrapper._getQualifier((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, PROV_QLFR);
            cIMObjectPath2 = cIMQualifier != null ? instanceProvider.createInstance(cIMObjectPath, cIMInstance) : providerCIMOMHandle.createInstance(cIMObjectPath, cIMInstance);
        }
        return cIMObjectPath2;
    }

    public static void deleteInstance(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath) throws CIMException {
        if (RCimWrapper.isRObject(cIMObjectPath) || RCimWrapper.isRAsso(cIMObjectPath)) {
            RCimWrapper.deleteInstance(cIMOMHandle, cIMObjectPath);
            return;
        }
        ProviderCIMOMHandle providerCIMOMHandle = (ProviderCIMOMHandle)cIMOMHandle;
        InstanceProvider instanceProvider = providerCIMOMHandle.getInternalProvider();
        if (cimmomType.equalsIgnoreCase("WEBM")) {
            instanceProvider.deleteInstance(cIMObjectPath);
        } else if (cimmomType.equalsIgnoreCase(cimmomType)) {
            CIMQualifier cIMQualifier = CimomWrapper._getQualifier((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, PROV_QLFR);
            if (cIMQualifier != null) {
                instanceProvider.deleteInstance(cIMObjectPath);
            } else {
                providerCIMOMHandle.deleteInstance(cIMObjectPath);
            }
        }
    }

    public static void setInstance(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        if (RCimWrapper.isRObject(cIMObjectPath) || RCimWrapper.isRAsso(cIMObjectPath)) {
            RCimWrapper.setInstance(cIMOMHandle, cIMObjectPath, cIMInstance);
            return;
        }
        ProviderCIMOMHandle providerCIMOMHandle = (ProviderCIMOMHandle)cIMOMHandle;
        InstanceProvider instanceProvider = providerCIMOMHandle.getInternalProvider();
        if (cimmomType.equalsIgnoreCase("WEBM")) {
            instanceProvider.setInstance(cIMObjectPath, cIMInstance);
        } else if (cimmomType.equalsIgnoreCase(cimmomType)) {
            CIMQualifier cIMQualifier = CimomWrapper._getQualifier((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, PROV_QLFR);
            if (cIMQualifier != null) {
                instanceProvider.setInstance(cIMObjectPath, cIMInstance);
            } else {
                providerCIMOMHandle.setInstance(cIMObjectPath, cIMInstance);
            }
        }
    }

    public static CIMInstance getInstance(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) throws CIMException {
        if (RCimWrapper.isRObject(cIMObjectPath) || RCimWrapper.isRAsso(cIMObjectPath)) {
            return RCimWrapper.getInstance(cIMOMHandle, cIMObjectPath);
        }
        CIMInstance cIMInstance = null;
        ProviderCIMOMHandle providerCIMOMHandle = (ProviderCIMOMHandle)cIMOMHandle;
        InstanceProvider instanceProvider = providerCIMOMHandle.getInternalProvider();
        if (cimmomType.equalsIgnoreCase("WEBM")) {
            cIMInstance = instanceProvider.getInstance(cIMObjectPath, cIMClass, bl);
        } else if (cimmomType.equalsIgnoreCase(cimmomType)) {
            CIMQualifier cIMQualifier = CimomWrapper._getQualifier((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, PROV_QLFR);
            cIMInstance = cIMQualifier != null ? instanceProvider.getInstance(cIMObjectPath, cIMClass, bl) : providerCIMOMHandle.getInstance(cIMObjectPath, bl);
        }
        return cIMInstance;
    }

    static int copyFoundInstances(Vector vector, Vector vector2) {
        int n;
        if (vector == null || vector.size() <= 0) {
            return 0;
        }
        for (n = 0; n < vector.size(); ++n) {
            vector2.add(vector.get(n));
        }
        return n;
    }

    static Vector getCecIdsFromAssignment(String[] stringArray, boolean bl) {
        Vector<String> vector = new Vector<String>();
        Vector<CIMObjectPath> vector2 = new Vector<CIMObjectPath>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            CIMObjectPath cIMObjectPath;
            if (stringArray[i].startsWith("cec") && !vector.contains(stringArray[i])) {
                vector.add(stringArray[i]);
                cIMObjectPath = PIHmcAccessUtils.getCOPFromInternalResInstId(stringArray[i]);
                if (cIMObjectPath == null) continue;
                vector2.add(cIMObjectPath);
                continue;
            }
            if (!stringArray[i].startsWith("lpar") || (cIMObjectPath = PIHmcAccessUtils.getCOPFromInternalResInstId(stringArray[i])) == null || vector.contains(string = PIHmcAccessUtils.getInternalParentResInstId(cIMObjectPath, "IBMHSC_ComputerSystem"))) continue;
            vector.add(string);
            cIMObjectPath = PIHmcAccessUtils.getCOPFromInternalResInstId(string);
            if (cIMObjectPath == null) continue;
            vector2.add(cIMObjectPath);
        }
        if (bl) {
            return vector2;
        }
        return vector;
    }

    static Vector getAssignedInstances(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, String[] stringArray, int n) throws CIMException {
        Vector vector = null;
        Vector<Object> vector2 = new Vector<Object>();
        Vector vector3 = null;
        switch (CimomWrapper.getAccessMrTypeIndex(cIMObjectPath)) {
            case 0: {
                vector3 = CimomWrapper.getCecIdsFromAssignment(stringArray, true);
                if (n == 0) {
                    CimomWrapper.copyFoundInstances(vector3, vector2);
                    break;
                }
                if (n != 1) break;
                for (int i = 0; i < vector3.size(); ++i) {
                    CIMInstance cIMInstance;
                    CIMObjectPath cIMObjectPath2 = (CIMObjectPath)vector3.get(i);
                    if (cIMObjectPath2 == null || (cIMInstance = RCimWrapper.getInstance(cIMOMHandle, cIMObjectPath2)) == null) continue;
                    vector2.add(cIMInstance);
                }
                break;
            }
            case 1: {
                CIMObjectPath cIMObjectPath3 = new CIMObjectPath("IBMHSC_CompSysPartition", cIMObjectPath.getNameSpace());
                for (int i = 0; i < stringArray.length; ++i) {
                    CIMInstance cIMInstance;
                    vector3 = null;
                    vector = null;
                    if (!stringArray[i].startsWith("lpar")) continue;
                    CIMObjectPath cIMObjectPath4 = PIHmcAccessUtils.getCOPFromInternalResInstId(stringArray[i]);
                    if (stringArray[i].indexOf(All_Lpar_Tag) > 0) {
                        CIMObjectPath cIMObjectPath5 = PIHmcAccessUtils.getParentCIMObjectPath(cIMObjectPath4, "IBMHSC_ComputerSystem");
                        if (n == 0) {
                            vector3 = RCimWrapper.associatorNames(cIMOMHandle, cIMObjectPath3, cIMObjectPath5);
                        } else if (n == 1) {
                            vector3 = RCimWrapper.associators(cIMOMHandle, cIMObjectPath3, cIMObjectPath5);
                        }
                        CimomWrapper.copyFoundInstances(vector3, vector2);
                        continue;
                    }
                    if (cIMObjectPath4 == null || (cIMInstance = RCimWrapper.getInstance(cIMOMHandle, cIMObjectPath4)) == null) continue;
                    if (n == 0) {
                        vector2.add(cIMObjectPath4);
                        continue;
                    }
                    if (n != 1) continue;
                    vector2.add(cIMInstance);
                }
                break;
            }
            case 2: {
                CIMObjectPath cIMObjectPath6 = new CIMObjectPath("IBMHSC_CompSysProfile", cIMObjectPath.getNameSpace());
                vector3 = CimomWrapper.getCecIdsFromAssignment(stringArray, true);
                for (int i = 0; i < vector3.size(); ++i) {
                    CIMObjectPath cIMObjectPath7 = (CIMObjectPath)vector3.get(i);
                    if (cIMObjectPath7 == null) continue;
                    if (n == 0) {
                        vector = RCimWrapper.associatorNames(cIMOMHandle, cIMObjectPath6, cIMObjectPath7);
                    } else if (n == 1) {
                        vector = RCimWrapper.associators(cIMOMHandle, cIMObjectPath6, cIMObjectPath7);
                    }
                    CimomWrapper.copyFoundInstances(vector, vector2);
                }
                break;
            }
            case 3: {
                CIMObjectPath cIMObjectPath8 = new CIMObjectPath("IBMHSC_PartitionProfile", cIMObjectPath.getNameSpace());
                CIMObjectPath cIMObjectPath9 = new CIMObjectPath("IBMHSC_CompSysPartition", cIMObjectPath.getNameSpace());
                for (int i = 0; i < stringArray.length; ++i) {
                    vector3 = null;
                    vector = null;
                    if (!stringArray[i].startsWith("lpar")) continue;
                    CIMObjectPath cIMObjectPath10 = PIHmcAccessUtils.getCOPFromInternalResInstId(stringArray[i]);
                    if (stringArray[i].indexOf(All_Lpar_Tag) > 0) {
                        CIMObjectPath cIMObjectPath11 = PIHmcAccessUtils.getParentCIMObjectPath(cIMObjectPath10, "IBMHSC_ComputerSystem");
                        vector3 = RCimWrapper.associatorNames(cIMOMHandle, cIMObjectPath9, cIMObjectPath11);
                        if (vector3 == null || vector3.size() <= 0) continue;
                        for (int j = 0; j < vector3.size(); ++j) {
                            cIMObjectPath10 = (CIMObjectPath)vector3.get(j);
                            if (cIMObjectPath10 != null) {
                                if (n == 0) {
                                    vector = RCimWrapper.associatorNames(cIMOMHandle, cIMObjectPath8, cIMObjectPath10);
                                } else if (n == 1) {
                                    vector = RCimWrapper.associators(cIMOMHandle, cIMObjectPath8, cIMObjectPath10);
                                }
                            }
                            CimomWrapper.copyFoundInstances(vector, vector2);
                        }
                        continue;
                    }
                    if (cIMObjectPath10 == null) continue;
                    if (n == 0) {
                        vector = RCimWrapper.associatorNames(cIMOMHandle, cIMObjectPath8, cIMObjectPath10);
                    } else if (n == 1) {
                        vector = RCimWrapper.associators(cIMOMHandle, cIMObjectPath8, cIMObjectPath10);
                    }
                    CimomWrapper.copyFoundInstances(vector, vector2);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < stringArray.length; ++i) {
                    CIMInstance cIMInstance;
                    CIMObjectPath cIMObjectPath12;
                    if (!stringArray[i].startsWith("frame") || (cIMObjectPath12 = PIHmcAccessUtils.getCOPFromInternalResInstId(stringArray[i])) == null || (cIMInstance = RCimWrapper.getInstance(cIMOMHandle, cIMObjectPath12)) == null) continue;
                    if (n == 0) {
                        vector2.add(cIMObjectPath12);
                        continue;
                    }
                    if (n != 1) continue;
                    vector2.add(cIMInstance);
                }
                break;
            }
        }
        return vector2;
    }

    public static Vector enumInstances(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
        String string;
        Object object;
        InstanceProvider instanceProvider;
        if (GlobalConfig.pluginAccessModule != null && CimomWrapper.getAccessMrTypeIndex(cIMObjectPath) >= 0 && !(instanceProvider = (object = HscLoginModule.getAcaClientHandle()).GetUserAssignment(string = PIHmcAccessUtils.getUserNameFromPrincipal(), 11))[0].equalsIgnoreCase("ALL:")) {
            return CimomWrapper.getAssignedInstances(cIMOMHandle, cIMObjectPath, bl, cIMClass, (String[])instanceProvider, 0);
        }
        object = null;
        if (RCimWrapper.isRObject(cIMObjectPath) || RCimWrapper.isRAsso(cIMObjectPath)) {
            return RCimWrapper.enumInstances(cIMOMHandle, cIMObjectPath, 5);
        }
        string = (ProviderCIMOMHandle)cIMOMHandle;
        instanceProvider = string.getInternalProvider();
        if (cimmomType.equalsIgnoreCase("WEBM")) {
            object = instanceProvider.enumInstances(cIMObjectPath, bl, cIMClass);
        } else if (cimmomType.equalsIgnoreCase(cimmomType)) {
            CIMQualifier cIMQualifier = CimomWrapper._getQualifier((CIMOMHandle)string, cIMObjectPath, PROV_QLFR);
            if (cIMQualifier != null) {
                object = instanceProvider.enumInstances(cIMObjectPath, bl, cIMClass);
            } else {
                Enumeration enumeration = string.enumInstances(cIMObjectPath, bl);
                if (enumeration != null) {
                    object = new Vector();
                    while (enumeration.hasMoreElements()) {
                        ((Vector)object).add(enumeration.nextElement());
                    }
                }
            }
        }
        return object;
    }

    public static Vector enumInstances(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
        String string;
        Object object;
        InstanceProvider instanceProvider;
        if (GlobalConfig.pluginAccessModule != null && CimomWrapper.getAccessMrTypeIndex(cIMObjectPath) >= 0 && !(instanceProvider = (object = HscLoginModule.getAcaClientHandle()).GetUserAssignment(string = PIHmcAccessUtils.getUserNameFromPrincipal(), 11))[0].equalsIgnoreCase("ALL:")) {
            return CimomWrapper.getAssignedInstances(cIMOMHandle, cIMObjectPath, bl, cIMClass, (String[])instanceProvider, 1);
        }
        if (RCimWrapper.isRObject(cIMObjectPath) || RCimWrapper.isRAsso(cIMObjectPath)) {
            return RCimWrapper.enumInstances(cIMOMHandle, cIMObjectPath, 4);
        }
        object = null;
        string = (ProviderCIMOMHandle)cIMOMHandle;
        instanceProvider = string.getInternalProvider();
        if (cimmomType.equalsIgnoreCase("WEBM")) {
            object = instanceProvider.enumInstances(cIMObjectPath, bl, cIMClass, bl2);
        }
        if (cimmomType.equalsIgnoreCase(cimmomType)) {
            CIMQualifier cIMQualifier = CimomWrapper._getQualifier((CIMOMHandle)string, cIMObjectPath, PROV_QLFR);
            if (cIMQualifier != null) {
                object = instanceProvider.enumInstances(cIMObjectPath, bl, cIMClass, bl2);
            } else {
                Enumeration enumeration = string.enumInstances(cIMObjectPath, bl, bl2);
                if (enumeration != null) {
                    object = new Vector();
                    while (enumeration.hasMoreElements()) {
                        ((Vector)object).add(enumeration.nextElement());
                    }
                }
            }
        }
        return object;
    }

    public static Vector execQuery(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) throws CIMException {
        if (RCimWrapper.isRObject(cIMObjectPath) || RCimWrapper.isRAsso(cIMObjectPath)) {
            System.out.println("CimomWrapper.execQuery not supported for repository objects");
            throw new HSCCIMException("CIM_ERR_NOT_SUPPORTED");
        }
        Vector vector = new Vector();
        ProviderCIMOMHandle providerCIMOMHandle = (ProviderCIMOMHandle)cIMOMHandle;
        InstanceProvider instanceProvider = providerCIMOMHandle.getInternalProvider();
        if (cimmomType.equalsIgnoreCase("WEBM")) {
            vector = instanceProvider.execQuery(cIMObjectPath, string, n, cIMClass);
        }
        if (cimmomType.equalsIgnoreCase(cimmomType)) {
            // empty if block
        }
        return vector;
    }

    static Vector getAssociatedLpar(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, String[] stringArray, int n) throws CIMException {
        Vector<Object> vector = new Vector<Object>();
        if (cIMObjectPath == null) {
            return vector;
        }
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_CompSysPartition", cIMObjectPath.getNameSpace());
        Vector vector2 = cIMObjectPath.getKeys();
        if (vector2 == null) {
            for (int i = 0; i < stringArray.length; ++i) {
                CIMInstance cIMInstance;
                if (!stringArray[i].startsWith("lpar")) continue;
                CIMObjectPath cIMObjectPath3 = PIHmcAccessUtils.getCOPFromInternalResInstId(stringArray[i]);
                if (stringArray[i].indexOf(All_Lpar_Tag) > 0) {
                    CIMObjectPath cIMObjectPath4 = PIHmcAccessUtils.getParentCIMObjectPath(cIMObjectPath3, "IBMHSC_ComputerSystem");
                    if (n == 0) {
                        vector2 = RCimWrapper.associatorNames(cIMOMHandle, cIMObjectPath2, cIMObjectPath4);
                    } else if (n == 1) {
                        vector2 = RCimWrapper.associators(cIMOMHandle, cIMObjectPath2, cIMObjectPath4);
                    }
                    CimomWrapper.copyFoundInstances(vector2, vector);
                    continue;
                }
                if (cIMObjectPath3 == null || (cIMInstance = RCimWrapper.getInstance(cIMOMHandle, cIMObjectPath3)) == null) continue;
                if (n == 0) {
                    vector.add(cIMObjectPath3);
                    continue;
                }
                if (n != 1) continue;
                vector.add(cIMInstance);
            }
        } else {
            String string = PIHmcAccessUtils.getPropValueFromKeys(vector2, "Name");
            if (string == null) {
                return vector;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                CIMInstance cIMInstance;
                if (!stringArray[i].startsWith("lpar") || stringArray[i].indexOf(string) <= 0) continue;
                if (stringArray[i].indexOf(All_Lpar_Tag) > 0) {
                    CIMObjectPath cIMObjectPath5 = PIHmcAccessUtils.getParentCIMObjectPath(PIHmcAccessUtils.getCOPFromInternalResInstId(stringArray[i]), "IBMHSC_ComputerSystem");
                    if (n == 0) {
                        vector2 = RCimWrapper.associatorNames(cIMOMHandle, cIMObjectPath2, cIMObjectPath5);
                    } else if (n == 1) {
                        vector2 = RCimWrapper.associators(cIMOMHandle, cIMObjectPath2, cIMObjectPath5);
                    }
                    CimomWrapper.copyFoundInstances(vector2, vector);
                    continue;
                }
                CIMObjectPath cIMObjectPath6 = PIHmcAccessUtils.getCOPFromInternalResInstId(stringArray[i]);
                if (cIMObjectPath6 == null || (cIMInstance = RCimWrapper.getInstance(cIMOMHandle, cIMObjectPath6)) == null) continue;
                if (n == 0) {
                    vector.add(cIMObjectPath6);
                    continue;
                }
                if (n != 1) continue;
                vector.add(cIMInstance);
            }
        }
        return vector;
    }

    public static Vector associatorNames(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, String string3) throws CIMException {
        Vector vector;
        Object object;
        Object object2;
        String[] stringArray;
        if (GlobalConfig.pluginAccessModule != null && mrTypes[0].equalsIgnoreCase(cIMObjectPath2.getObjectName()) && "IBMHSC_CompSysPartition".equalsIgnoreCase(cIMObjectPath.getObjectName()) && !(stringArray = (object2 = HscLoginModule.getAcaClientHandle()).GetUserAssignment((String)(object = PIHmcAccessUtils.getUserNameFromPrincipal()), 11))[0].equalsIgnoreCase("ALL:")) {
            return CimomWrapper.getAssociatedLpar(cIMOMHandle, cIMObjectPath2, stringArray, 0);
        }
        if (RCimWrapper.isRAsso(cIMObjectPath)) {
            return RCimWrapper.associatorNames(cIMOMHandle, cIMObjectPath, cIMObjectPath2);
        }
        object2 = new Vector();
        object = (ProviderCIMOMHandle)cIMOMHandle;
        stringArray = (String[])object.getInternalProvider();
        if (cimmomType.equalsIgnoreCase("WEBM")) {
            object2 = stringArray.associatorNames(cIMObjectPath, cIMObjectPath2, string, string2, string3);
        } else if (cimmomType.equalsIgnoreCase(cimmomType) && (vector = CimomWrapper.enumInstances(cIMOMHandle, cIMObjectPath, false, cIMOMHandle.getClass(cIMObjectPath, false), false)) != null && vector.size() != 0) {
            for (int i = 0; i < vector.size(); ++i) {
                CIMObjectPath cIMObjectPath3;
                Vector vector2;
                CIMObjectPath cIMObjectPath4;
                Vector vector3;
                CIMInstance cIMInstance = (CIMInstance)vector.elementAt(i);
                if (string2 == null || string2.trim().length() == 0) {
                    vector3 = cIMInstance.getKeyValuePairs();
                    cIMObjectPath4 = null;
                    vector2 = null;
                    if (vector3 == null || vector3.size() == 0) continue;
                    for (int j = 0; j < vector3.size(); ++j) {
                        CIMProperty cIMProperty = (CIMProperty)vector3.elementAt(j);
                        cIMObjectPath3 = null;
                        try {
                            cIMObjectPath3 = (CIMObjectPath)cIMProperty.getValue().getValue();
                        }
                        catch (ClassCastException classCastException) {
                            continue;
                        }
                        if (CimomWrapper.sameObjectPath(cIMObjectPath3, cIMObjectPath2)) {
                            cIMObjectPath4 = cIMObjectPath3;
                            continue;
                        }
                        vector2 = cIMObjectPath3;
                    }
                    if (cIMObjectPath4 == null || vector2 == null) continue;
                    ((Vector)object2).add(vector2);
                    continue;
                }
                vector3 = cIMInstance.getProperty(string2);
                cIMObjectPath4 = null;
                if (vector3 == null) continue;
                try {
                    cIMObjectPath4 = (CIMObjectPath)vector3.getValue().getValue();
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                if (!CimomWrapper.sameObjectPath(cIMObjectPath4, cIMObjectPath2)) continue;
                if (string3 == null || string3.length() <= 0) {
                    vector2 = cIMInstance.getKeyValuePairs();
                    CIMObjectPath cIMObjectPath5 = null;
                    if (vector2 == null || vector2.size() == 0) continue;
                    for (int j = 0; j < vector2.size(); ++j) {
                        cIMObjectPath3 = (CIMProperty)vector2.elementAt(j);
                        CIMObjectPath cIMObjectPath6 = null;
                        try {
                            cIMObjectPath6 = (CIMObjectPath)cIMObjectPath3.getValue().getValue();
                        }
                        catch (ClassCastException classCastException) {
                            continue;
                        }
                        if (CimomWrapper.sameObjectPath(cIMObjectPath6, cIMObjectPath2)) continue;
                        cIMObjectPath5 = cIMObjectPath6;
                    }
                    if (cIMObjectPath5 == null) continue;
                    ((Vector)object2).add(cIMObjectPath5);
                    continue;
                }
                vector2 = (CIMObjectPath)cIMInstance.getProperty(string3).getValue().getValue();
                ((Vector)object2).add(vector2);
            }
        }
        return object2;
    }

    public static Vector associatorNamesWithOutAccessChk(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, String string3) throws CIMException {
        Vector vector;
        if (RCimWrapper.isRAsso(cIMObjectPath)) {
            return RCimWrapper.associatorNames(cIMOMHandle, cIMObjectPath, cIMObjectPath2);
        }
        Vector vector2 = new Vector();
        ProviderCIMOMHandle providerCIMOMHandle = (ProviderCIMOMHandle)cIMOMHandle;
        AssociatorProvider associatorProvider = (AssociatorProvider)providerCIMOMHandle.getInternalProvider();
        if (cimmomType.equalsIgnoreCase("WEBM")) {
            vector2 = associatorProvider.associatorNames(cIMObjectPath, cIMObjectPath2, string, string2, string3);
        } else if (cimmomType.equalsIgnoreCase(cimmomType) && (vector = CimomWrapper.enumInstances(cIMOMHandle, cIMObjectPath, false, cIMOMHandle.getClass(cIMObjectPath, false), false)) != null && vector.size() != 0) {
            for (int i = 0; i < vector.size(); ++i) {
                CIMObjectPath cIMObjectPath3;
                Vector vector3;
                CIMObjectPath cIMObjectPath4;
                Vector vector4;
                CIMInstance cIMInstance = (CIMInstance)vector.elementAt(i);
                if (string2 == null || string2.trim().length() == 0) {
                    vector4 = cIMInstance.getKeyValuePairs();
                    cIMObjectPath4 = null;
                    vector3 = null;
                    if (vector4 == null || vector4.size() == 0) continue;
                    for (int j = 0; j < vector4.size(); ++j) {
                        CIMProperty cIMProperty = (CIMProperty)vector4.elementAt(j);
                        cIMObjectPath3 = null;
                        try {
                            cIMObjectPath3 = (CIMObjectPath)cIMProperty.getValue().getValue();
                        }
                        catch (ClassCastException classCastException) {
                            continue;
                        }
                        if (CimomWrapper.sameObjectPath(cIMObjectPath3, cIMObjectPath2)) {
                            cIMObjectPath4 = cIMObjectPath3;
                            continue;
                        }
                        vector3 = cIMObjectPath3;
                    }
                    if (cIMObjectPath4 == null || vector3 == null) continue;
                    vector2.add(vector3);
                    continue;
                }
                vector4 = cIMInstance.getProperty(string2);
                cIMObjectPath4 = null;
                if (vector4 == null) continue;
                try {
                    cIMObjectPath4 = (CIMObjectPath)vector4.getValue().getValue();
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                if (!CimomWrapper.sameObjectPath(cIMObjectPath4, cIMObjectPath2)) continue;
                if (string3 == null || string3.length() <= 0) {
                    vector3 = cIMInstance.getKeyValuePairs();
                    CIMObjectPath cIMObjectPath5 = null;
                    if (vector3 == null || vector3.size() == 0) continue;
                    for (int j = 0; j < vector3.size(); ++j) {
                        cIMObjectPath3 = (CIMProperty)vector3.elementAt(j);
                        CIMObjectPath cIMObjectPath6 = null;
                        try {
                            cIMObjectPath6 = (CIMObjectPath)cIMObjectPath3.getValue().getValue();
                        }
                        catch (ClassCastException classCastException) {
                            continue;
                        }
                        if (CimomWrapper.sameObjectPath(cIMObjectPath6, cIMObjectPath2)) continue;
                        cIMObjectPath5 = cIMObjectPath6;
                    }
                    if (cIMObjectPath5 == null) continue;
                    vector2.add(cIMObjectPath5);
                    continue;
                }
                vector3 = (CIMObjectPath)cIMInstance.getProperty(string3).getValue().getValue();
                vector2.add(vector3);
            }
        }
        return vector2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Vector referenceNames(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string) throws CIMException {
        if (RCimWrapper.isRAsso(cIMObjectPath)) {
            return RCimWrapper.referenceNames(cIMOMHandle, cIMObjectPath, cIMObjectPath2);
        }
        Vector vector = new Vector();
        ProviderCIMOMHandle providerCIMOMHandle = (ProviderCIMOMHandle)cIMOMHandle;
        AssociatorProvider associatorProvider = (AssociatorProvider)providerCIMOMHandle.getInternalProvider();
        if (cimmomType.equalsIgnoreCase("WEBM")) {
            return associatorProvider.referenceNames(cIMObjectPath, cIMObjectPath2, string);
        }
        if (!cimmomType.equalsIgnoreCase(cimmomType)) return vector;
        Vector vector2 = CimomWrapper.enumInstances(cIMOMHandle, cIMObjectPath, false, cIMOMHandle.getClass(cIMObjectPath, false), false);
        String string2 = cIMObjectPath.getNameSpace();
        if (vector2 == null) return vector;
        if (vector2.size() == 0) return vector;
        int n = 0;
        while (n < vector2.size()) {
            block13: {
                CIMObjectPath cIMObjectPath3;
                Vector vector3;
                CIMInstance cIMInstance = (CIMInstance)vector2.elementAt(n);
                if (string == null || string.trim().length() == 0) {
                    vector3 = cIMInstance.getKeyValuePairs();
                    cIMObjectPath3 = null;
                    if (vector3 != null && vector3.size() != 0) {
                        for (int i = 0; i < vector3.size(); ++i) {
                            CIMProperty cIMProperty = (CIMProperty)vector3.elementAt(i);
                            CIMObjectPath cIMObjectPath4 = null;
                            try {
                                cIMObjectPath4 = (CIMObjectPath)cIMProperty.getValue().getValue();
                            }
                            catch (ClassCastException classCastException) {
                                continue;
                            }
                            if (!CimomWrapper.sameObjectPath(cIMObjectPath4, cIMObjectPath2)) continue;
                            cIMObjectPath3 = cIMObjectPath4;
                            CIMObjectPath cIMObjectPath5 = new CIMObjectPath(cIMObjectPath.getObjectName(), string2);
                            cIMObjectPath5.setKeys(cIMInstance.getKeyValuePairs());
                            vector.add(cIMObjectPath5);
                            break;
                        }
                    }
                } else {
                    vector3 = cIMInstance.getProperty(string);
                    cIMObjectPath3 = null;
                    if (vector3 != null) {
                        try {
                            cIMObjectPath3 = (CIMObjectPath)vector3.getValue().getValue();
                        }
                        catch (NullPointerException nullPointerException) {
                            break block13;
                        }
                        if (CimomWrapper.sameObjectPath(cIMObjectPath3, cIMObjectPath2)) {
                            CIMObjectPath cIMObjectPath6 = new CIMObjectPath(cIMObjectPath.getObjectName(), string2);
                            cIMObjectPath6.setKeys(cIMInstance.getKeyValuePairs());
                            vector.add(cIMObjectPath6);
                        }
                    }
                }
            }
            ++n;
        }
        return vector;
    }

    public static Vector associators(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, String string3, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        Vector vector;
        Object object;
        Object object2;
        String[] stringArray2;
        if (GlobalConfig.pluginAccessModule != null && mrTypes[0].equalsIgnoreCase(cIMObjectPath2.getObjectName()) && "IBMHSC_CompSysPartition".equalsIgnoreCase(cIMObjectPath.getObjectName()) && !(stringArray2 = (object2 = HscLoginModule.getAcaClientHandle()).GetUserAssignment((String)(object = PIHmcAccessUtils.getUserNameFromPrincipal()), 11))[0].equalsIgnoreCase("ALL:")) {
            return CimomWrapper.getAssociatedLpar(cIMOMHandle, cIMObjectPath2, stringArray2, 1);
        }
        if (RCimWrapper.isRAsso(cIMObjectPath)) {
            return RCimWrapper.associators(cIMOMHandle, cIMObjectPath, cIMObjectPath2);
        }
        object2 = new Vector();
        object = (ProviderCIMOMHandle)cIMOMHandle;
        stringArray2 = (String[])object.getInternalProvider();
        if (cimmomType.equalsIgnoreCase("WEBM")) {
            object2 = stringArray2.associators(cIMObjectPath, cIMObjectPath2, string, string2, string3, bl, bl2, stringArray);
        } else if (cimmomType.equalsIgnoreCase(cimmomType) && (vector = CimomWrapper.enumInstances(cIMOMHandle, cIMObjectPath, false, cIMOMHandle.getClass(cIMObjectPath, false), false)) != null && vector.size() != 0) {
            for (int i = 0; i < vector.size(); ++i) {
                CIMObjectPath cIMObjectPath3;
                Vector vector2;
                CIMObjectPath cIMObjectPath4;
                Vector vector3;
                CIMInstance cIMInstance = (CIMInstance)vector.elementAt(i);
                if (string2 == null || string2.trim().length() == 0) {
                    vector3 = cIMInstance.getKeyValuePairs();
                    cIMObjectPath4 = null;
                    vector2 = null;
                    if (vector3 == null || vector3.size() == 0) continue;
                    for (int j = 0; j < vector3.size(); ++j) {
                        CIMProperty cIMProperty = (CIMProperty)vector3.elementAt(j);
                        cIMObjectPath3 = null;
                        try {
                            cIMObjectPath3 = (CIMObjectPath)cIMProperty.getValue().getValue();
                        }
                        catch (ClassCastException classCastException) {
                            continue;
                        }
                        if (CimomWrapper.sameObjectPath(cIMObjectPath3, cIMObjectPath2)) {
                            cIMObjectPath4 = cIMObjectPath3;
                            continue;
                        }
                        vector2 = cIMObjectPath3;
                    }
                    if (cIMObjectPath4 == null || vector2 == null) continue;
                    CIMInstance cIMInstance2 = CimomWrapper.getInstance(cIMOMHandle, (CIMObjectPath)vector2, cIMOMHandle.getClass((CIMObjectPath)vector2, false), false);
                    ((Vector)object2).add(cIMInstance2);
                    continue;
                }
                vector3 = cIMInstance.getProperty(string2);
                cIMObjectPath4 = null;
                if (vector3 == null) continue;
                try {
                    cIMObjectPath4 = (CIMObjectPath)vector3.getValue().getValue();
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                if (!CimomWrapper.sameObjectPath(cIMObjectPath4, cIMObjectPath2)) continue;
                if (string3 == null || string3.length() <= 0) {
                    vector2 = cIMInstance.getKeyValuePairs();
                    CIMObjectPath cIMObjectPath5 = null;
                    if (vector2 == null || vector2.size() == 0) continue;
                    for (int j = 0; j < vector2.size(); ++j) {
                        cIMObjectPath3 = (CIMProperty)vector2.elementAt(j);
                        CIMObjectPath cIMObjectPath6 = null;
                        try {
                            cIMObjectPath6 = (CIMObjectPath)cIMObjectPath3.getValue().getValue();
                        }
                        catch (ClassCastException classCastException) {
                            continue;
                        }
                        if (CimomWrapper.sameObjectPath(cIMObjectPath6, cIMObjectPath2)) continue;
                        cIMObjectPath5 = cIMObjectPath6;
                    }
                    if (cIMObjectPath5 == null) continue;
                    CIMInstance cIMInstance3 = CimomWrapper.getInstance(cIMOMHandle, cIMObjectPath5, cIMOMHandle.getClass(cIMObjectPath5, false), false);
                    ((Vector)object2).add(cIMInstance3);
                    continue;
                }
                vector2 = (CIMObjectPath)cIMInstance.getProperty(string3).getValue().getValue();
                CIMInstance cIMInstance4 = CimomWrapper.getInstance(cIMOMHandle, (CIMObjectPath)vector2, cIMOMHandle.getClass((CIMObjectPath)vector2, false), false);
                ((Vector)object2).add(cIMInstance4);
            }
        }
        return object2;
    }

    public static Vector associatorsWithoutAccessChk(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, String string3, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        Vector vector;
        if (RCimWrapper.isRAsso(cIMObjectPath)) {
            return RCimWrapper.associators(cIMOMHandle, cIMObjectPath, cIMObjectPath2);
        }
        Vector vector2 = new Vector();
        ProviderCIMOMHandle providerCIMOMHandle = (ProviderCIMOMHandle)cIMOMHandle;
        AssociatorProvider associatorProvider = (AssociatorProvider)providerCIMOMHandle.getInternalProvider();
        if (cimmomType.equalsIgnoreCase("WEBM")) {
            vector2 = associatorProvider.associators(cIMObjectPath, cIMObjectPath2, string, string2, string3, bl, bl2, stringArray);
        } else if (cimmomType.equalsIgnoreCase(cimmomType) && (vector = CimomWrapper.enumInstances(cIMOMHandle, cIMObjectPath, false, cIMOMHandle.getClass(cIMObjectPath, false), false)) != null && vector.size() != 0) {
            for (int i = 0; i < vector.size(); ++i) {
                CIMObjectPath cIMObjectPath3;
                Vector vector3;
                CIMObjectPath cIMObjectPath4;
                Vector vector4;
                CIMInstance cIMInstance = (CIMInstance)vector.elementAt(i);
                if (string2 == null || string2.trim().length() == 0) {
                    vector4 = cIMInstance.getKeyValuePairs();
                    cIMObjectPath4 = null;
                    vector3 = null;
                    if (vector4 == null || vector4.size() == 0) continue;
                    for (int j = 0; j < vector4.size(); ++j) {
                        CIMProperty cIMProperty = (CIMProperty)vector4.elementAt(j);
                        cIMObjectPath3 = null;
                        try {
                            cIMObjectPath3 = (CIMObjectPath)cIMProperty.getValue().getValue();
                        }
                        catch (ClassCastException classCastException) {
                            continue;
                        }
                        if (CimomWrapper.sameObjectPath(cIMObjectPath3, cIMObjectPath2)) {
                            cIMObjectPath4 = cIMObjectPath3;
                            continue;
                        }
                        vector3 = cIMObjectPath3;
                    }
                    if (cIMObjectPath4 == null || vector3 == null) continue;
                    CIMInstance cIMInstance2 = CimomWrapper.getInstance(cIMOMHandle, (CIMObjectPath)vector3, cIMOMHandle.getClass((CIMObjectPath)vector3, false), false);
                    vector2.add(cIMInstance2);
                    continue;
                }
                vector4 = cIMInstance.getProperty(string2);
                cIMObjectPath4 = null;
                if (vector4 == null) continue;
                try {
                    cIMObjectPath4 = (CIMObjectPath)vector4.getValue().getValue();
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                if (!CimomWrapper.sameObjectPath(cIMObjectPath4, cIMObjectPath2)) continue;
                if (string3 == null || string3.length() <= 0) {
                    vector3 = cIMInstance.getKeyValuePairs();
                    CIMObjectPath cIMObjectPath5 = null;
                    if (vector3 == null || vector3.size() == 0) continue;
                    for (int j = 0; j < vector3.size(); ++j) {
                        cIMObjectPath3 = (CIMProperty)vector3.elementAt(j);
                        CIMObjectPath cIMObjectPath6 = null;
                        try {
                            cIMObjectPath6 = (CIMObjectPath)cIMObjectPath3.getValue().getValue();
                        }
                        catch (ClassCastException classCastException) {
                            continue;
                        }
                        if (CimomWrapper.sameObjectPath(cIMObjectPath6, cIMObjectPath2)) continue;
                        cIMObjectPath5 = cIMObjectPath6;
                    }
                    if (cIMObjectPath5 == null) continue;
                    CIMInstance cIMInstance3 = CimomWrapper.getInstance(cIMOMHandle, cIMObjectPath5, cIMOMHandle.getClass(cIMObjectPath5, false), false);
                    vector2.add(cIMInstance3);
                    continue;
                }
                vector3 = (CIMObjectPath)cIMInstance.getProperty(string3).getValue().getValue();
                CIMInstance cIMInstance4 = CimomWrapper.getInstance(cIMOMHandle, (CIMObjectPath)vector3, cIMOMHandle.getClass((CIMObjectPath)vector3, false), false);
                vector2.add(cIMInstance4);
            }
        }
        return vector2;
    }

    public static Vector references(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        Vector vector;
        String string2 = cIMObjectPath2.getNameSpace();
        if (RCimWrapper.isRAsso(cIMObjectPath)) {
            return RCimWrapper.references(cIMOMHandle, cIMObjectPath, cIMObjectPath2);
        }
        Vector vector2 = new Vector();
        ProviderCIMOMHandle providerCIMOMHandle = (ProviderCIMOMHandle)cIMOMHandle;
        AssociatorProvider associatorProvider = (AssociatorProvider)providerCIMOMHandle.getInternalProvider();
        if (cimmomType.equalsIgnoreCase("WEBM")) {
            vector2 = associatorProvider.references(cIMObjectPath, cIMObjectPath2, string, bl, bl2, stringArray);
        } else if (cimmomType.equalsIgnoreCase(cimmomType) && (vector = CimomWrapper.enumInstances(cIMOMHandle, cIMObjectPath, false, cIMOMHandle.getClass(cIMObjectPath, false), false)) != null && vector.size() != 0) {
            block4: for (int i = 0; i < vector.size(); ++i) {
                CIMObjectPath cIMObjectPath3;
                Vector vector3;
                CIMInstance cIMInstance = (CIMInstance)vector.elementAt(i);
                if (string == null || string.trim().length() == 0) {
                    vector3 = cIMInstance.getKeyValuePairs();
                    cIMObjectPath3 = null;
                    if (vector3 == null || vector3.size() == 0) continue;
                    for (int j = 0; j < vector3.size(); ++j) {
                        CIMProperty cIMProperty = (CIMProperty)vector3.elementAt(j);
                        CIMObjectPath cIMObjectPath4 = null;
                        try {
                            cIMObjectPath4 = (CIMObjectPath)cIMProperty.getValue().getValue();
                        }
                        catch (ClassCastException classCastException) {
                            continue;
                        }
                        if (!CimomWrapper.sameObjectPath(cIMObjectPath4, cIMObjectPath2)) continue;
                        cIMObjectPath3 = cIMObjectPath4;
                        vector2.add(cIMInstance);
                        continue block4;
                    }
                    continue;
                }
                vector3 = cIMInstance.getProperty(string);
                cIMObjectPath3 = null;
                if (vector3 == null) continue;
                try {
                    cIMObjectPath3 = (CIMObjectPath)vector3.getValue().getValue();
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                if (!CimomWrapper.sameObjectPath(cIMObjectPath3, cIMObjectPath2)) continue;
                vector2.add(cIMInstance);
            }
        }
        return vector2;
    }

    private static Vector associateOP(ProviderCIMOMHandle providerCIMOMHandle, CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, boolean bl, boolean bl2, String[] stringArray, int n) throws CIMException {
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath3 = null;
        CIMProperty[] cIMPropertyArray = new CIMProperty[2];
        Vector vector = null;
        Vector<Object> vector2 = new Vector<Object>();
        InstanceProvider instanceProvider = providerCIMOMHandle.getInternalProvider();
        Vector vector3 = instanceProvider.enumInstances(cIMObjectPath, true, providerCIMOMHandle.getClass(cIMObjectPath, true), true);
        if (vector3 == null) {
            return null;
        }
        block6: for (int i = 0; i < vector3.size(); ++i) {
            cIMInstance = (CIMInstance)vector3.elementAt(i);
            vector = cIMInstance.getProperties();
            if (vector == null || vector.size() <= 0) continue;
            int n2 = 0;
            cIMPropertyArray[0] = null;
            cIMPropertyArray[1] = null;
            cIMObjectPath3 = null;
            for (int j = 0; j < vector.size(); ++j) {
                cIMPropertyArray[n2] = (CIMProperty)vector.elementAt(j);
                if (cIMPropertyArray[n2].getType().isReferenceType() && ++n2 >= 2) break;
            }
            if (cIMPropertyArray[0] == null || cIMPropertyArray[1] == null) continue;
            if (cIMPropertyArray[0].getValue().getValue().equals(cIMObjectPath2)) {
                cIMObjectPath3 = (CIMObjectPath)cIMPropertyArray[1].getValue().getValue();
            } else if (cIMPropertyArray[1].getValue().getValue().equals(cIMObjectPath2)) {
                cIMObjectPath3 = (CIMObjectPath)cIMPropertyArray[0].getValue().getValue();
            }
            if (cIMObjectPath3 == null) continue;
            switch (n) {
                case 1: {
                    cIMInstance = instanceProvider.getInstance(cIMObjectPath3, providerCIMOMHandle.getClass(cIMObjectPath3, true), true);
                    if (cIMInstance == null) continue block6;
                    vector2.add(cIMInstance);
                    continue block6;
                }
                case 2: {
                    vector2.add(cIMObjectPath3);
                    continue block6;
                }
                case 3: {
                    vector2.add(cIMInstance);
                    continue block6;
                }
                case 4: {
                    vector2.add(new CIMObjectPath(cIMObjectPath.getObjectName(), cIMInstance.getKeyValuePairs()));
                    continue block6;
                }
                default: {
                    System.out.println("The invalid mode is " + n);
                    throw new HSCCIMException("CIM_ERR_INVALID_PARAMETER");
                }
            }
        }
        if (vector2 != null) {
            return vector2;
        }
        return null;
    }

    private static CIMQualifier _getQualifier(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, String string) {
        CIMClass cIMClass = null;
        CIMQualifier cIMQualifier = null;
        try {
            cIMClass = cIMOMHandle.getClass(cIMObjectPath, true);
            if (cIMClass instanceof CIMClass) {
                cIMQualifier = cIMClass.getQualifier(string);
            }
        }
        catch (CIMException cIMException) {
            System.out.println(" Could not find the class or qualifier.\n" + cIMException.getMessage());
            cIMQualifier = null;
        }
        return cIMQualifier;
    }

    public static void ssleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public static boolean sameObjectPath(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2) {
        if (cIMObjectPath != null && cIMObjectPath2 != null) {
            String string;
            CIMProperty cIMProperty;
            int n;
            Vector vector = cIMObjectPath.getKeys();
            Vector vector2 = cIMObjectPath2.getKeys();
            if (vector.size() != vector2.size()) {
                return false;
            }
            Hashtable<String, CIMValue> hashtable = new Hashtable<String, CIMValue>();
            Hashtable hashtable2 = new Hashtable();
            for (n = 0; n < vector.size(); ++n) {
                cIMProperty = (CIMProperty)vector.elementAt(n);
                string = cIMProperty.getName();
                hashtable.put(string, cIMProperty.getValue());
            }
            for (n = 0; n < vector2.size(); ++n) {
                cIMProperty = (CIMProperty)vector2.elementAt(n);
                string = cIMProperty.getName();
                CIMValue cIMValue = (CIMValue)hashtable.get(string);
                CIMValue cIMValue2 = cIMProperty.getValue();
                if (cIMValue == null && cIMValue2 != null || cIMValue != null && cIMValue2 == null) {
                    return false;
                }
                if (cIMValue == null && cIMValue2 == null) continue;
                Object object = cIMValue.getValue();
                Object object2 = cIMValue2.getValue();
                if (object == null && object2 != null || object != null && object2 == null) {
                    return false;
                }
                if (object == null && object2 == null) continue;
                Class<?> clazz = object.getClass();
                Class<?> clazz2 = object2.getClass();
                if (!clazz.getName().equals(clazz2.getName())) {
                    try {
                        if (object.toString().equals(object2.toString())) continue;
                        return false;
                    }
                    catch (Throwable throwable) {
                        return false;
                    }
                }
                if (!(clazz.getName().equalsIgnoreCase("org.snia.wbem.cim.CIMObjectPath") ? !CimomWrapper.sameObjectPath((CIMObjectPath)object, (CIMObjectPath)object2) : !object.equals(object2))) continue;
                return false;
            }
            return true;
        }
        return cIMObjectPath == null && cIMObjectPath2 == null;
    }

    public static Object getProperty(CIMInstance cIMInstance, String string) {
        Object object = null;
        CIMValue cIMValue = cIMInstance.getProperty(string).getValue();
        if (cIMValue != null) {
            object = cIMValue.getValue();
        }
        return object;
    }

    public static boolean setProperty(CIMInstance cIMInstance, String string, Object object) throws CIMException {
        return CimomWrapper.setProperty(cIMInstance, string, object, null);
    }

    public static boolean setProperty(CIMInstance cIMInstance, String string, Object object, CIMDataType cIMDataType) throws CIMException {
        Object object2;
        CIMValue cIMValue = cIMInstance.getProperty(string).getValue();
        if (cIMValue != null ? ((object2 = cIMValue.getValue()) != null ? object2.equals(object) : object == null) : object == null) {
            return false;
        }
        if (cIMDataType == null) {
            cIMInstance.setProperty(string, new CIMValue(object));
        } else {
            cIMInstance.setProperty(string, new CIMValue(object, cIMDataType));
        }
        return true;
    }

    public static boolean setPropertyString(CIMInstance cIMInstance, String string, String string2) throws CIMException {
        String string3;
        CIMValue cIMValue = cIMInstance.getProperty(string).getValue();
        if (cIMValue != null ? ((string3 = (String)cIMValue.getValue()) != null ? string3.equalsIgnoreCase(string2) : string2 == null) : string2 == null) {
            return false;
        }
        cIMInstance.setProperty(string, new CIMValue((Object)string2));
        return true;
    }

    public static boolean setPropertyCIMValue(CIMInstance cIMInstance, String string, CIMValue cIMValue) throws CIMException {
        CIMValue cIMValue2 = cIMInstance.getProperty(string).getValue();
        if (cIMValue2 != null && cIMValue2.equals((Object)cIMValue)) {
            return false;
        }
        cIMInstance.setProperty(string, cIMValue);
        return true;
    }

    public static Object getKeyFromOp(CIMObjectPath cIMObjectPath, String string) {
        Vector vector = cIMObjectPath.getKeys();
        for (int i = 0; i < vector.size(); ++i) {
            CIMProperty cIMProperty = (CIMProperty)vector.elementAt(i);
            if (!cIMProperty.getName().equals(string)) continue;
            return cIMProperty.getValue().getValue();
        }
        return null;
    }

    public static Object getInstPropValue(CIMInstance cIMInstance, String string) {
        CIMProperty cIMProperty = cIMInstance.getProperty(string);
        if (cIMProperty == null) {
            return null;
        }
        CIMValue cIMValue = cIMProperty.getValue();
        if (cIMValue == null) {
            return null;
        }
        return cIMValue.getValue();
    }
}

